<?php
// XXX total item count won't match in tables because the top table uses LIMIT
// and the bottom table uses a date interval

require_once "./functions.php";

restrict_access();

$conn = new_db_connection();

// TODO refactor
$sql = "select t1.sale_date, t1.sales_count, t2.item_count, t1.total_cash, t1.total_transfer, t2.total_price from ";
$sql .= "(select date(date) as sale_date, count(*) as sales_count, sum(cash) as total_cash, sum(transfer) as total_transfer from sales group by sale_date) t1 ";
$sql .= "join (select date(sales.date) as sale_date, count(*) as item_count, sum(items.price) as total_price from items join sales on sales.id=sale_id group by sale_date) t2 on t1.sale_date = t2.sale_date ";

$from = get_string_or_null("from");
$to = get_string_or_null("to");

// TODO limit rows
$sales=[];
// TODO allow open intervals
if ($from && $to) {
	$sql .= "where t1.sale_date >= date(?) and t1.sale_date <= date(?) order by t1.sale_date desc";
	$sales = select_query($conn, $sql, "ss", [$from, $to]);
}else{
	$sql .= "order by t1.sale_date desc limit 20";
	$sales = select_query($conn, $sql);
}

$sql = "select items.type as type, count(*) as count from items join sales on sale_id=sales.id ";

if ($from && $to) {
	$sql .= "where date(sales.date) >= ? and  date(sales.date) <= ? group by items.type order by items.type";
	$items = select_query($conn, $sql, "ss", [$from, $to]);
}else{
	$sql .= "where date(sales.date) >= subdate(curdate(), interval 20 day) group by items.type order by items.type";
	$items = select_query($conn, $sql);
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width; initial-scale=1.0;" />
	<link rel="stylesheet" href="css/jquery-ui.css" />
	<link rel="stylesheet" href="css/styles.css" />
	<title>Resumen por dia</title>
</head>
<body>
	<?php require_once 'navbar.php' ?>
	
	<h1>Ventas por dia</h1>
	
	<form>
		Fecha Desde: <input type="text" name="from" id="dateFrom">&nbsp;&nbsp;&nbsp;&nbsp;
		Fecha Hasta: <input type="text" name="to" id="dateTo">&nbsp;&nbsp;&nbsp;&nbsp;
		<input type="submit" value="Buscar">
	</form>

	<div style="width:900px">
		<canvas id="chart"></canvas>
	</div>
	
	<table border="1">
		<tr>
			<th>Fecha</th>
			<th>Cantidad Ventas</th>
			<th>Cantidad Prendas</th>
			<th>Total Efectivo</th>
			<th>Total Transferencia</th>
			<th>Total ganado</th>
			<th>Precio total</th>
			<th>Diferencia</th>
			<th>(%) Diferencia</th>
			<th></th>
		</tr>
		<?php
				// init accumulators
				$total_sales = 0;
				$total_items_sold = 0;
				$total_cash = 0;
				$total_transfer = 0;
				$total_price = 0;
		?>
		<?php foreach ($sales as $sale): ?>
			<?php
			$money_diff = $sale["total_transfer"] + $sale["total_cash"] - $sale["total_price"];
			$row_color = ($money_diff > 0 ? 'lightgreen' : ($money_diff < 0 ? 'pink' : 'default'));
			?>
			<tr style="background-color: <?= $row_color ?>">
				<td><?= $sale["sale_date"] ?></td>
				<td style="text-align:right"><?= format_number($sale["sales_count"]) ?></td>
				<td style="text-align:right"><?= format_number($sale["item_count"]) ?></td>
				<td style="text-align:right"><?= format_money($sale["total_cash"]) ?></td>
				<td style="text-align:right"><?= format_money($sale["total_transfer"]) ?></td>
				<td style="text-align:right">
					<?= format_money($sale["total_transfer"] + $sale["total_cash"]) ?>
				</td>
				<td style="text-align:right"><?= format_money($sale["total_price"]) ?></td>
				<td style="text-align:right">
					<?= format_money($sale["total_transfer"] + $sale["total_cash"] - $sale["total_price"]) ?>
				</td>
				<td style="text-align:right">
					<?= format_number(($sale["total_transfer"] + $sale["total_cash"] - $sale["total_price"]) /
						($sale["total_transfer"] + $sale["total_cash"]) * 100) ?>%
				</td>
				
				<td><a href="day_overview.php?date=<?= $sale["sale_date"] ?>" target="_blank">Detalle</a></td>
			</tr>
			<?php
				// update accumulators
				$total_sales += $sale['sales_count'];
				$total_items_sold += $sale['item_count'];
				$total_cash += $sale['total_cash'];
				$total_transfer += $sale['total_transfer'];
				$total_price += $sale['total_price'];
			?>
		<?php endforeach ?>
		<tr style="background-color: lightgray; font-weight: bold">
			<td>TOTALES</td>
			<td style="text-align: right"><?= format_number($total_sales) ?></td>
			<td style="text-align: right"><?= format_number($total_items_sold) ?></td>
			<td style="text-align: right"><?= format_money($total_cash) ?></td>
			<td style="text-align: right"><?= format_money($total_transfer) ?></td>
			<td style="text-align: right"><?= format_money($total_cash + $total_transfer) ?></td>
			<td style="text-align: right"><?= format_money($total_price) ?></td>
			<td style="text-align: right"><?= format_money($total_cash + $total_transfer - $total_price) ?></td>
			<td style="text-align: right">
			<?= format_number(($total_cash + $total_transfer - $total_price) /
					($total_cash + $total_transfer) * 100) ?>%
			</td>
			<td></td>
		</tr>
	</table>
	<!-- TODO add download link -->
	<hr />
	<h1>Prendas vendidas por tipo</h1>
	
	<div style="width:700px">
		<canvas id="chart2"></canvas>
	</div>
	<table border="1">
		<tr>
			<th>Tipo de prenda</th>
			<th>Vendidas</th>
		</tr>
		<?php foreach ($items as $item) { ?>
			<tr>
				<td><?= htmlentities($item["type"]) ?></td>
				<td style="text-align:right"><?= $item["count"] ?></td>
			</tr>
		<?php } ?>
	</table>
	
	<script src="js/jquery-3.7.1.js"></script>
	<script src="js/jquery-ui.js"></script>
	<script src="js/datepicker-es.js"></script>
		<script>
		$(function(){
			$("#dateFrom")
				.datepicker($.datepicker.regional["es"])
				.datepicker("option","dateFormat","yy-mm-dd");
				
			$("#dateTo")
				.datepicker($.datepicker.regional["es"])
				.datepicker("option","dateFormat","yy-mm-dd");
		})
	</script>
	
<?php

function mydate($str){
	$days=['Dom','Lun','Mar','Mie','Jue','Vie','Sab'];
	$months=['Ene','Feb','Mar','Abr','May','Jun','Jul','Ago','Sep','Oct','Nov','Dic'];

	$date = DateTimeImmutable::createFromFormat('Y-m-d', $str);
	$weekday = intval($date->format('w'));
	$day = $date->format('j');
	$month = intval($date->format('n'));
	$year = $date->format('y');

	return "'".$days[$weekday]." $day ".$months[$month-1]." $year"."'";
}

?>
	
	
	<script src="js/chart.js"></script>
	<script>
		var labels = [
			<?php
				$dates = array_map(function($x){ return mydate($x['sale_date']); }, array_reverse($sales));
				echo implode(",", $dates);
			?>
		];
	
		var data = [
			<?php
				$values = array_map(function($x){ 
					return $x["total_transfer"] + $x["total_cash"];
				}, array_reverse($sales));
				echo implode(",", $values);
			?>
		];
	
		var config = {
			type: "bar",
			data:{
				labels: labels,
				datasets:[
					{
						label:"Total ganado",
						data:data
					}
				]
			}
		};
	
		var chart = document.getElementById("chart");
		new Chart(chart, config);
	</script>
	
	<script>
		var labels = [
			<?php
				$types = array_map(function($x){ return "'".$x["type"]."'"; }, $items);
				echo implode(",", $types);
			?>
		];
	
		var data = [
			<?php
				$counts = array_map(function($x){ return $x["count"]; }, $items);
				echo implode(",", $counts);
			?>
		];
	
		var config = {
			type: "bar",
			data:{
				labels: labels,
				datasets:[
					{
						label:"Prendas vendidas",
						data:data
					}
				]
			}
		};
	
		var chart = document.getElementById("chart2");
		new Chart(chart, config);
	</script>
</body>
</html>