<?php

require_once "./functions.php";

$message = NULL;
$message_color = 'green';

if (is_post_request()) {
	$item_ids = get_string_or_null('item_ids');
	if (!$item_ids)
		die('missing item_ids param');
	
	// TODO validate format and improve tokenize
	$item_ids = explode(',', $item_ids);
	
	$cash = get_string_or_null('cash');
	$transfer = get_string_or_null('transfer');
	if ($cash === NULL && $transfer === NULL)
		die('missing "cash" and "transfer" params');
	
	// TODO validate type
	$type = get_string_or_null('type');
	$description = get_string_or_null('description');
	
	$conn = new_db_connection();
	$conn->begin_transaction();
	
	// create sale
	$sql = 'INSERT INTO sales (type, description, cash, transfer) VALUES (?, ?, ?, ?)';
	$types = 'ssii';
	$values = [$type, $description, $cash ?? 0, $transfer ?? 0];
	$sale_id = exec_query($conn, $sql, $types, $values);
	
	// point items to the new sale
	$placeholders = '?' . str_repeat(',?', count($item_ids) - 1);
	$sql = "UPDATE items SET sale_id = ? WHERE sale_id IS NULL AND id IN ($placeholders)";
	$types = 'i' . str_repeat('i', count($item_ids));
	$values = array_merge([$sale_id], $item_ids);
	exec_query($conn, $sql, $types, $values);
	
	// abort sale if at least one of the items was already sold
	$sold_items = select_query($conn, "SELECT COUNT(*) AS count FROM items WHERE sale_id = $sale_id")[0]['count'];
	if ($sold_items === count($item_ids)) {
		$conn->commit();
		$message = "Nueva venta #$sale_id creada correctamente.";
	} else {
		$conn->rollback();
		$message = 'Error creando venta: Algunas prendas ya estaban vendidas (posiblemente desde otra pestaña del navegador).';
		$message_color = 'red';
	}
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
	<meta charset="utf-8" />
	<title>Nueva venta - yendovintage</title>
	<meta name="viewport" content="width=device-width; initial-scale=1.0;" />
	<link rel="stylesheet" href="css/styles.css" />
</head>
<body>
	<?php require_once 'navbar.php' ?>
	
	<p id="message" style="color: <?= $message_color ?>; font-weight: bold; margin-top:1em"><?= $message ?></p>
	<h2>Nueva venta</h2>
	Número: <input type="text" id="itemId" />
	<button id="addItem" onclick="addItem()">Agregar prenda</button>
	<p style="font-style: italic">Usar "," para ingresar varias prendas a la vez. Ejemplo: 1,2,3</p>
	<div id="idError" style="color:red"></div>
	
	<form method="POST" onsubmit="return submitForm()">
		<input type="hidden" id="item_ids" name="item_ids">
		Tipo de venta:
		<select id="type" name="type" required>
			<option value="">-- Seleccionar ---</option>
			<option>Local</option>
			<option>Online</option>
		</select>
		<br><br>
		Descripcion: <input type="text" name="description">
		<br><br>
		<div id="itemsError" style="color:red"></div>
		<table border="1">
			<tr>
				<th>Número</th>
				<th>Fecha ingreso</th>
				<th>Tipo</th>
				<th>Marca</th>
				<th>Talle</th>
				<th>Color</th>
				<th>Precio</th>
				<th>Ubicación</th>
				<th>Descripción</th>
				<th></th>
			</tr>
			<tbody id="itemRows"></tbody>
		</table>
		<br><br>	
		Subtotal = $<span id="subtotal">0</span>
		<br><br>
		Monto efectivo: $<input type="text" name="cash" id="cash" autocomplete="off">
		<br><br>
		Monto transferencia: $<input type="text" name="transfer" id="transfer" autocomplete="off">
		<div id="priceError" style="color:red;display:none">Completar al menos un monto!</div>
		<br><br>
		<input type="submit" value="Completar venta">
	</form>
	
	<script src="js/jquery-3.7.1.js"></script>
	<script>
	var items = new Map;

	function submitForm(){
		$("#message").hide();
		if (!items.size){
			$("#itemsError").text("Debe haber al menos una prenda").show();
			return false;
		}
		$("#itemsError").hide();
		
		var cash = $("#cash").val().trim();
		var transfer = $("#transfer").val().trim();
		
		if (!cash.length && !transfer.length){
			$("#priceError").show();
			return false;
		}
		$("#priceError").hide();
		
		cash = cash.length ? parseInt(cash) : 0;
		transfer = transfer.length ? parseInt(transfer) : 0;
		var subtotal = getSubtotal();
		
		if (cash+transfer !== subtotal){
			var diff = subtotal - (cash+transfer);
			var message = "El precio total de las prendas es $" + subtotal + ".\n\n";
			message += "El monto cobrado en efectivo + transferencia es $" + (cash+transfer) + ".\n\n";
			
			
			if (diff>0){
				message+="Se esta haciendo un descuento de $" + diff + " (%" + Math.ceil(diff/subtotal*100) + ").\n\n";
			}else{
				message+="Nos estan entregando a favor $" + (-diff) + " (%" + Math.ceil(-diff/subtotal*100) + ").\n\n";
			}			
			
			message += "Continuar?";
			
			if (!window.confirm(message))
				return false;
		}else{
			if (!window.confirm("Esta seguro de continuar con la venta?"))
				return false;
		}
		
		var temp=[];
		items.forEach(function(val,id){ temp.push(id) });
		$("#item_ids").val(temp.join(","));
		
		return true;
	}
	
	function addItem(){
		var idNode = $("#itemId");
		var id = idNode.val().trim();
		idNode.val('');
		if (!id.length) return;
		$("button,:submit").prop("disabled",true);
		
		$.getJSON("items.php", {"item_ids":id, "json":1})
			.done(function(data){
				$("button,:submit").prop("disabled",false);
				
				var errorNode = $('#idError');
				if (data.length === 0) {
					errorNode.html('No se hallaron prendas con los números ingresados.').show();
					return;
				}
				
				
				var errorHtml = '';
				data.forEach(function(item) {
					if (item.sale_id)
						errorHtml += '<p>La prenda #' + item.id + ' ya fué vendida.</p>';
					else
						items.set(item.id, item);
				});
				
				
				errorNode.html(errorHtml);
				errorNode.toggle(!!errorNode);
				
				updateTable();
				updateSubtotal();
			})
			.fail(function(data){
				$("#idError").text("error buscando prenda").show();
				$("button,:submit").prop("disabled",false);
			});
	}
	
	function updateTable(){
		var container = $("#itemRows").empty();
		
		if (!items.size){
			container.html('<tr><td colspan="9" align="center">No hay registros</td></tr>');
		}
		
		var props = ["id","date","type","brand","size","color","price","location","description"];
		
		items.forEach(function(item){
			var row = $("<tr>").appendTo(container);
			props.forEach(function(prop){
				var cell = $("<td>").appendTo(row);
				var val = item[prop];
				cell.text(val);
				if (typeof val === "number")
					cell.css("text-align", "right");
			});
			
			var cell = $("<td>").appendTo(row);
			$("<button>").text("remover").appendTo(cell).on("click", function(){
				items.delete(item.id);
				updateTable();
				updateSubtotal();
				return false;
			})
		});
	}
	
	function getSubtotal(){
		var subtotal=0;
		items.forEach(function(item){
			subtotal+=item.price;
		});
		return subtotal;
	}
	
	function updateSubtotal(){
		$("#subtotal").text(getSubtotal());
	}
	
	$(function(){
		updateTable();
		$("#cash,#transfer").on("keypress",function(e){
			if(!e.key.match("^\\d$"))
				e.preventDefault();
		}).on("paste",function(e){
			e.preventDefault();
		});
		
		$("#itemId").on("keypress",function(e){
			if (e.key === "Enter"){
				addItem();
				return;
			}
			
			if(!e.key.match("^\\d$") && e.key !== ',')
				e.preventDefault();
		}).on("paste",function(e){
			e.preventDefault();
		});
	})
	
	</script>
</body>
</html>
