<?php

require_once "./functions.php";

$message = null;

if (is_post_request()) {	
	$id = get_string_or_null("id");
	if (!$id)
		die('missing id param');
	$conn = new_db_connection();
	$rows=select_query($conn, "select count(*) as count from items where id=?","i",[$id]);
	if ($rows[0]["count"] === 0){
		$fields = ["id", "type", "brand", "size", "color", "price", "description", "location"];
		$sql = "insert into items (". implode(",", $fields) .") values (?". str_repeat(",?", count($fields)-1) .")";
		$values=array_map(function($f){ return get_string_or_null($f); },$fields);

		exec_query($conn, $sql, "issssiss", $values);
		$message = "Prenda cargada correctamente";
	}else
		$message = "ERROR: la prenda con codigo ".$id." ya existe";
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
	<meta charset="utf-8" />
	<title>Cargar prenda - yendovintage</title>
	<meta name="viewport" content="width=device-width; initial-scale=1.0;" />
	<link rel="stylesheet" href="css/styles.css" />
	<style>
		table {
			border: 0;
		}
		td {
			text-align: left;
		}
	</style>
</head>
<body>
	<?php require_once 'navbar.php' ?>
	
	<?php if ($message) echo '<p>' . $message . '</p>' ?>
	
	<h2>Cargar prenda</h2>

	<form method="POST">		
		<table>
		<tr>
			<td>Codigo:</td>
			<td><input type="text" name="id" id="id" autocomplete="off" required>*</td>
		</tr>
		<tr>
			<td>Tipo:</td>
			<td>
				<select name="type" id="type" required>*
					<option value="">-- Seleccionar --</option>
					<option>Bermuda</option>
					<option>Buzo</option>
					<option>Camisa</option>
					<option>Campera</option>
					<option>Chaleco</option>
					<option>Gorro</option>
					<option>Jardinero</option>
					<option>Otros</option>
					<option>Pantalon</option>
					<option>Remera</option>
				</select>
			</td>
		</tr>
		<tr>
			<td>Marca:</td>
			<td><input type="text" name="brand"></td>
		</tr>
		<tr>
			<td>Talle:</td>
			<td><input type="text" name="size"></td>
		</tr>
		<tr>
			<td>Color:</td>
			<td><input type="text" name="color"></td>
		</tr>
		<tr>
			<td>Precio:</td>
			<td><input type="text" name="price" id="price" autocomplete="off" required>*</td>
		</tr>
		<tr>
			<td>Ubicacion:</td>
			<td><input type="text" name="location"></td>
		</tr>
		<tr>
			<td>Descripcion:</td>
			<td><textarea name="description"></textarea></td>
		</tr>
		</table>
		<br><input type="submit" value="Guardar">
	</form>
	
	<script src="js/jquery-3.7.1.js"></script>
	<script>
	$(function(){
		$("#id,#price").on("keypress",function(e){
			if(!e.key.match("^\\d$"))
				e.preventDefault();
		}).on("paste",function(e){
			e.preventDefault();
		});
	});
	</script>
</body>
</html>