<?php

require_once "./functions.php";

$conn = new_db_connection();

$sql = 'SELECT DISTINCT(DATE(sales.date)) AS date FROM sales ORDER BY DATE(sales.date) DESC LIMIT 1 OFFSET 4';
$min_date = select_query($conn, $sql)[0]['date'];

$sql = <<<SQL
SELECT id, DATE(date) AS date, date AS datetime, type, cash, transfer, description, (SELECT COUNT(*) FROM items WHERE sale_id = sales.id) AS sold_items
FROM sales WHERE DATE(sales.date) >= ? ORDER BY date DESC
SQL;
$sales = select_query($conn, $sql, 's', [$min_date]);


$by_date = [];
foreach ($sales as $sale) {
	$date = $sale['date'];
	if (!isset($by_date[$date])) {
		$by_date[$date] = [];
	}
	$by_date[$date][] = $sale;
}

?>

<!DOCTYPE html>
<html>
<head>
	<meta name="viewport" content="width=device-width; initial-scale=1.0;" />
	<link rel="stylesheet" href="css/styles.css" />
</head>
<body>
	<?php require_once 'navbar.php' ?>
	
	<h2>Ultimas ventas</h2>	
	<table border="1">
		<tr>
			<th>Número</th>
			<th>Fecha</th>
			<th>Tipo</th>
			<th>Prendas vendidas</th>
			<th>Efectivo</th>
			<th>Transferencia</th>
			<th>Descripción</th>
			<th></th>
		</tr>
		<?php 
		foreach ($by_date as $date => $sales) {
			$total_sold_items = 0;
			$total_cash = 0;
			$total_transfer = 0;
			
			foreach ($sales as $sale) { ?>
				<tr>
					<td style="text-align:right"><?= $sale['id'] ?></td>
					<td><?= $sale['date'] ?></td>
					<td><?= $sale['type'] ?></td>
					<td style="text-align:right"><?= $sale['sold_items'] ?></td>
					<td style="text-align:right"><?= format_money($sale['cash']) ?></td>
					<td style="text-align:right"><?= format_money($sale['transfer']) ?></td>
					<td><?= htmlentities($sale['description'] ?? '') ?></td>
					<td><button onclick="window.open('items.php?sale_id=<?= $sale['id'] ?>&preview=1', '', 'top=0,left=0,width=800,height=320')">detalle</button></td>
				</tr>
				<?php
				$total_sold_items += $sale['sold_items'];
				$total_cash += $sale['cash'];
				$total_transfer += $sale['transfer'];
			} ?>
			<tr style="background-color: lightgray">
				<td colspan="3">SUBTOTAL</td>
				<td style="text-align:right"><?= $total_sold_items ?></td>
				<td style="text-align:right"><?= format_money($total_cash) ?></td>
				<td style="text-align:right"><?= format_money($total_transfer) ?></td>
				<td></td>
				<td></td>
			</tr>
		<?php } ?>
	</table>
	
	
	
	
	
	
</body>
</html>
