<?php

function new_db_connection() {
	mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
	try {
		require_once __DIR__ . '/config/db_config.php';
		return new mysqli($DB_HOST, $DB_USER, $DB_PASSWORD, $DB_NAME, $DB_PORT);
	} catch(Exception $e) {
		die('error connecting to db: ' . $e->getMessage());
	}
}

function select_query($conn, $sql, $bind_types = '', $bind_values = []) {
	try {
		$stmt = $conn->prepare($sql);
		if ($bind_types)
			$stmt->bind_param($bind_types, ...$bind_values);
		$stmt->execute();
		$result = $stmt->get_result();
		return $result->fetch_all(MYSQLI_ASSOC);
	} catch(Exception $e) {
		die('select query error: ' . $e->getMessage());
	}
}

function exec_query($conn, $sql, $bind_types = '', $bind_values = []) {
	try {
		$stmt = $conn->prepare($sql);
		if ($bind_types)
			$stmt->bind_param($bind_types, ...$bind_values);
		$stmt->execute();
		return $conn->insert_id;
	} catch(Exception $e) {
		die('exec error: ' . $e->getMessage());
	}
}

function get_string_or_null($key) {
	if (!isset($_REQUEST[$key])) {
		return NULL;
	}
	
	$value = $_REQUEST[$key];
	
	if (!is_string($value))
		return NULL;
	
	$value = trim($value);
	
	return (strlen($value) === 0 ? NULL : $value);
}

function is_post_request() {
	return strtoupper($_SERVER['REQUEST_METHOD']) === 'POST';
}

function tokenize_string($str) {
	if (!$str || !is_string($str))
		return [];
	
	return preg_split('/\s+/', $str, 0, PREG_SPLIT_NO_EMPTY);
}

function check_admin() {
	return ($_SERVER['REMOTE_USER'] === 'admin');
}

function restrict_access() {
	if (!check_admin())
		die('access denied');
}

// XXX https://www.php.net/manual/en/function.number-format
function format_number($value) {		
	$value = intval($value);
	
	if ($value < 0)
		return '-' . format_number(-$value);
	
	$result = '';
	
	while ($value >= 1000) {
		$aux = strval($value % 1000);
		$digits = str_pad($aux, 3, '0', STR_PAD_LEFT);
		
		$result = ($digits . ($result ? '.' : '') . $result);
		$value = intval($value / 1000);
	}
	
	return (strval($value) . ($result ? '.' : '') . $result);
}

function format_money($value) {
	if ($value < 0)
		return '-$' . format_number(-$value);

	return '$' . format_number($value);
}