<?php

require_once "./functions.php";

restrict_access();

$message="";

if (is_post_request()){
	$item_ids_string = get_string_or_null("item_ids");
	$new_price =get_string_or_null("new_price");
	$new_location =get_string_or_null("new_location");
	
	if (!$item_ids_string)
		die('missing item_ids param');
	
	$item_ids = explode(',', $item_ids_string);
	
	if ($new_price !== NULL || $new_location !== NULL){
		$bind_types = '';
		$bind_values = [];
		$sql_update = '';
		if ($new_price !== NULL){
			$sql_update .= 'price = ?';
			$bind_types .= 'i';
			$bind_values[] = $new_price;
		}
		if ($new_location !== NULL){
			$sql_update .= ', location = ?';
			$bind_types .= 's';
			$bind_values[] = $new_location;
		}
		
		$sql_update = trim($sql_update, ',');
		$sql_in = '(' . rtrim(str_repeat('?,', count($item_ids)), ',') . ')';
		$bind_types .= str_repeat('i', count($item_ids));
		$bind_values = array_merge($bind_values, $item_ids);
		
		$conn = new_db_connection();
		
		$sql = "UPDATE items SET $sql_update WHERE sale_id IS NULL AND id IN $sql_in";
		exec_query($conn, $sql, $bind_types, $bind_values);
		
		$message="Valores actualizados correctamente";
	}
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
	<meta charset="utf-8" />
	<title>Editar prendas - yendovintage</title>
	<meta name="viewport" content="width=device-width; initial-scale=1.0;" />
	<link rel="stylesheet" href="css/styles.css" />
</head>
<body>
	<?php require_once 'navbar.php' ?>
	<div id="message" style="color:green;"><?= $message ?></div>
	<h2>Editar prendas</h2>
	Texto: <input type="text" id="search" onkeydown="searchInputKeyup(event)"/>
	Numero: <input type="text" id="numberInput" onkeydown="searchInputKeyup(event)"/>
	Ubicacion: <input type="text" id="locationInput" onkeydown="searchInputKeyup(event)"/>
	<button id="searchButton" onclick="search(event)">Buscar</button>
	<p>Nota: se pueden buscar varios numeros separandolos por coma.</p>
	
	<h3>Resultados de busqueda</h3>
	<table border="1">
		<tr>
			<th>Numero</th>
			<th>Fecha ingreso</th>
			<th>Tipo</th>
			<th>Marca</th>
			<th>Talle</th>
			<th>Color</th>
			<th>Precio</th>
			<th>Ubicacion</th>
			<th>Descripcion</th>
			<th></th>
		</tr>
		<tbody id="results"></tbody>
	</table>
	<br>
	<button onclick="addSelection()">Agregar</button>
	<br><br>
	<h3>Prendas seleccionadas</h3>
	<table border="1">
		<tr>
			<th>Numero</th>
			<th>Fecha ingreso</th>
			<th>Tipo</th>
			<th>Marca</th>
			<th>Talle</th>
			<th>Color</th>
			<th>Precio</th>
			<th>Ubicacion</th>
			<th>Descripcion</th>
		</tr>
		<tbody id="selected"></tbody>
	</table>
	<div id="selectedError" style="display:none;color:red">Debe seleccionar al menos una prenda</div>
	<br><br>
	<form method="POST" onsubmit="return submitForm()">
		<input type="hidden" id="item_ids" name="item_ids">
		Nuevo precio: $<input type="text" id="newPrice" name="new_price" autocomplete="off">
		<br><br>
		Nueva ubicacion: <input type="text" id="newLocation" name="new_location" autocomplete="off">
		<br><br>
		<input type="submit" value="Guardar cambios">
	</form>

	<script src="js/jquery-3.7.1.js"></script>
	<script>
		var resultItems = new Map;
		var selectedItems = new Map;
	
		function search(e){
			$(e.target).text("Buscando...");
			$("button,:submit").prop('disabled', true);
			var text = $('#search').val();
			var itemNumber = $('#numberInput').val();
			var itemLocation = $('#locationInput').val();
			var messageNode = $('#message');
			
			$.getJSON("items.php", {"search_text": text, 'item_ids': itemNumber, 'location': itemLocation, "only_unsold":1, "json":1})
				.done(function(data){
					messageNode.hide();
					resultItems.clear();
					data.forEach(function(item){
						resultItems.set(item.id, item);
					});
					updateResultsTable();
					$("button,:submit").prop('disabled', false);
					$(e.target).text("Buscar");
				})
				.fail(function(data){
					messageNode.text('error buscando "'+text+'"').css("color","red").show();
					$("button,:submit").prop('disabled', false);
					$(e.target).text("Buscar");
				});
		}
		
		// trigger a search as if the search button was clicked
		function searchInputKeyup(e){
			if (e.key==='Enter'){
				$('#searchButton').click();
			}
		}
		
		function updateResultsTable(){
			var rowsNode = $("#results").empty();
			
			if (!resultItems.size){
				rowsNode.append('<tr><td colspan="10" align="center">No hay registros</td></tr>');
				return;
			}

			resultItems.forEach(function(item){
				var row = createItemRow(item);
				var check = $("<input>").attr("type", "checkbox").val(item.id);
				$("<td>").append(check).appendTo(row);
				rowsNode.append(row);
			});
		}
		
		function addSelection(){
			var checked = $("#results input:checked");
			var update=false;
			checked.each(function(){
				var node = $(this);
				var id = parseInt(node.val());
				if (selectedItems.has(id))
					return;
				
				selectedItems.set(id, resultItems.get(id));
				update=true;
			});
			
			if (update){
				updateSelectedTable();
				$('#selectedError').hide();
			}
		}
		
		function updateSelectedTable(){
			var table=$("#selected");
			table.empty();
			
			if (!selectedItems.size){
				table.append('<tr><td colspan="9" align="center">No hay registros</td></tr>')
			}
			
			selectedItems.forEach(function(item){
				createItemRow(item).appendTo(table);
			});
		}
		
		function createItemRow(item){
			var columns = ["id","date","type","brand","size","color","price","location","description"];
			var row = $("<tr>");
			columns.forEach(function(col){
				var val = item[col];
				var cell = $("<td>").text(val).appendTo(row);
				
				if (typeof val === "number")
					cell.css("text-align", "right");
			});
			return row;
		}
		
		function submitForm(){
			if (selectedItems.size==0){
				$('#selectedError').show();
				return false;
			}
			
			$('#selectedError').hide();
			
			var item_ids = [];
			selectedItems.forEach(function(item){
				item_ids.push(item.id);
			})
			
			$("#item_ids").val(item_ids.join(","));
			
			return window.confirm("Importante! Revisar cuidadosamente las prendas seleccionadas y los nuevos valores.\n\nConfirmar operacion?");
		}
		
		$(function(){
			updateResultsTable();
			updateSelectedTable();
			
			$("#newPrice").on("keypress", function(e){
				if (!e.key.match("^\\d$"))
					e.preventDefault();
			}).on("paste",function(e){
				e.preventDefault();
			});
		});
	</script>
</body>
</html>