<?php

require_once "./functions.php";

restrict_access();

$id = get_string_or_null("id");
if (!$id)
	die("missing item id");

$conn = new_db_connection();

$message=null;
if (is_post_request()) {
	$sql = "update items set price=?, description=?, location=? where id=? and sale_id is null";
	$values=[
		get_string_or_null("price"),
		get_string_or_null("description"),
		get_string_or_null("location"),
		$id
	];
	
	exec_query($conn, $sql, "issi", $values);
	
	$message = "Operacion exitosa";
}

$items = select_query($conn, "select id, type, brand, color, size, description, price, location, sale_id from items where id = ?", "i", [$id]);

if (count($items) != 1)
	die("fetching item $id didn't return exactly 1 record");

$item = $items[0];

?>

<!DOCTYPE html>
<html lang="es">
<head>
	<meta charset="utf-8" />
	<title>Editar prenda - yendovintage</title>
	<meta name="viewport" content="width=device-width; initial-scale=1.0;" />
	<link rel="stylesheet" href="css/styles.css" />
</head>
<body>
	<?php require_once 'navbar.php' ?>
	<?php if ($message) echo '<p style="color: green">' . $message . '</p>'; ?>
	<h2>Editar prenda</h2>
	<form method="POST">		
		<table>
		<tr>
			<td>Codigo:</td>
			<td><?= $item["id"] ?></td>
		</tr>		
		<tr>
			<td>Tipo:</td>
			<td><?= $item["type"] ?></td>
		</tr>
		<tr>
			<td>Marca:</td>
			<td><?= htmlentities($item["brand"]) ?></td>
		</tr>
		<tr>
			<td>Talle:</td>
			<td><?= htmlentities($item["size"]) ?></td>
		</tr>
		<tr>
			<td>Color:</td>
			<td><?= htmlentities($item["color"]) ?></td>
		</tr>
		<tr>
			<td>Precio:</td>
			<td><input type="text" name="price" value="<?= $item["price"] ?>" required autocomplete="off"> *</td>
		</tr>
		<tr>
			<td>Ubicacion:</td>
			<td><input type="text" name="location" value="<?= htmlentities($item["location"]) ?>"></td>
		</tr>
		<tr>
			<td>Descripcion:</td>
			<td><textarea name="description"><?= htmlentities($item["description"]) ?></textarea></td>
		</tr>
		</table>
		<br>
		<input type="submit" value="Guardar">
	</form>
</body>
</html>