<?php

require_once "./functions.php";

restrict_access();

date_default_timezone_set("America/Argentina/Buenos_Aires");

$date = get_string_or_null("date");
if (!$date)
	die('missing date param');

$conn = new_db_connection();

$sql = "select id, date, type,  cash, transfer, description, (select count(*) from items where sale_id = sales.id) as item_count, ";
$sql .= " (select sum(price) from items where sale_id = sales.id) as total_price ";
$sql .= " from sales where date(date) = ? order by date asc";
$sales = select_query($conn, $sql, "s", [$date]);

$sql = "select i.id as id, i.date as item_date, i.type as type, brand, size, color, price, location, i.description, s.date as sale_date, s.type as sale_type ";
$sql .= "from items i left join sales s on sale_id = s.id where date(s.date) = ? order by s.date asc";
$solditems = select_query($conn, $sql, "s", [$date]);

$sql = "select i.type as type, count(*) as count, sum(price) as price from items i left join sales s on sale_id=s.id where date(s.date)=? ";
$sql .= "group by i.type order by i.type asc";
$groupbytype = select_query($conn, $sql, "s", [$date]);


$sql = "select count(*) as count, sum(price) as price from items i left join sales s on sale_id=s.id where date(s.date)=?";
$rows = select_query($conn, $sql, "s", [$date]);
$total_items=$rows[0]["count"];
$total_price=$rows[0]["price"]===null ? 0 : $rows[0]["price"];

$sql = "select sum(cash) as cash, sum(transfer) as transfer from sales where date(date) = ?";
$rows = select_query($conn, $sql, "s", [$date]);
$total_cash=$rows[0]["cash"]===null ? 0 : $rows[0]["cash"];
$total_transfer=$rows[0]["transfer"]===null ? 0 : $rows[0]["transfer"];

?>

<!DOCTYPE html>
<html lang="es">
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width; initial-scale=1.0;" />
	<link rel="stylesheet" href="css/jquery-ui.css" />
	<link rel="stylesheet" href="css/styles.css" />
	<title>Resumen <?= $date ?></title>
</head>
<body>
	<?php require_once 'navbar.php' ?>
	
	<h2>Resumen de ventas el día: <?= $date ?></h2>

	<h3>Ventas</h3>
	<table border="1">
		<tr>
			<th>Numero</th>
			<th>Fecha</th>
			<th>Tipo</th>
			<th>Descripcion</th>
			<th>Cantidad prendas</th>
			<th>Efectivo</th>
			<th>Transferencia</th>
			<th>Total ganado</th>
			<th>Precio total</th>
			<th>Diferencia</th>
			<th></th>
		</tr>
		<?php foreach ($sales as $sale) { ?>
			<tr>
				<td style="text-align:right"><?= $sale["id"] ?></td>
				<td><?= $sale["date"] ?></td>
				<td><?= $sale["type"] ?></td>
				<td><?= htmlentities($sale["description"]) ?></td>
				<td style="text-align:right"><?= format_number($sale["item_count"]) ?></td>
				<td style="text-align:right"><?= format_money($sale["cash"]) ?></td>
				<td style="text-align:right"><?= format_money($sale["transfer"]) ?></td>
				<td style="text-align:right">
					<?= format_money($sale["transfer"] + $sale["cash"]) ?>
				</td>
				<td style="text-align:right"><?= format_money($sale["total_price"]) ?></td>
				<td style="text-align:right">
					<?= format_money($sale["transfer"] + $sale["cash"] - $sale["total_price"]) ?>
				</td>
				
				<td><button onclick="window.open('items.php?sale_id=<?= $sale["id"] ?>&preview=1', '', 'top=0,left=0,width=900,height=400')">detalle</button></td>
			</tr>
		<?php } ?>
	</table>
	<h3>Prendas vendidas</h3>
	<table border="1">
		<tr>
			<th>Numero</th>
			<th>Fecha ingreso</th>
			<th>Tipo</th>
			<th>Marca</th>
			<th>Talle</th>
			<th>Color</th>
			<th>Precio</th>
			<th>Ubicacion</th>
			<th>Descripcion</th>
			<th>Fecha vendido</th>
			<th>Tipo venta</th>
		</tr>
		<?php foreach ($solditems as $item) { ?>
			<tr>
				<td style="text-align:right"><?= $item["id"] ?></td>
				<td><?= $item["item_date"] ?></td>
				<td><?= htmlentities($item["type"]) ?></td>
				<td><?= htmlentities($item["brand"]) ?></td>
				<td><?= htmlentities($item["size"]) ?></td>
				<td><?= htmlentities($item["color"]) ?></td>
				<td style="text-align:right"><?= format_money($item["price"]) ?></td>
				<td><?= htmlentities($item["location"]) ?></td>
				<td><?= htmlentities($item["description"]) ?></td>
				<td><?= $item["sale_date"] ?></td>
				<td><?= $item["sale_type"] ?></td>
			
			</tr>
		<?php } ?>
		
	</table>
	
	<br>
	
	<h3>Totales por tipo</h3>
	<table border="1">
		<tr>
			<th>Tipo</th>
			<th>Cantidad</th>
			<th>Valor total</th>
		</tr>
		<?php foreach ($groupbytype as $group) { ?>
			<tr>
				<td><?= htmlentities($group["type"]) ?></td>
				<td style="text-align:right"><?= $group["count"] ?></td>
				<td style="text-align:right">$<?= $group["price"] ?></td>
			</tr>
		<?php } ?>
		
	</table>
</body>
</html>